// Omi Webhook Payload Types

export interface TranscriptSegment {
  text: string;
  speaker: string;
  speakerId: number;
  is_user: boolean;
  start: number;
  end: number;
}

export interface ActionItem {
  description: string;
  completed: boolean;
}

export interface StructuredMemory {
  title: string;
  overview: string;
  emoji: string;
  category: string;
  action_items: ActionItem[];
  events: any[];
}

export interface MemoryPayload {
  id: string;
  created_at: string;
  started_at: string;
  finished_at: string;
  transcript_segments: TranscriptSegment[];
  structured: StructuredMemory;
  apps_response: any[];
  discarded: boolean;
}

export interface OmiConfig {
  webhookSecret?: string;
  storeMemories?: boolean;
  storeTranscripts?: boolean;
  storeAudio?: boolean;
  memoryPath?: string;
  notifyAgent?: boolean;
}
