# 🔗 OmiMesh

**Connect your Omi AI wearable to OpenClaw**

Memories, transcripts, and context flow seamlessly into your agent.

## Features

- **Memory Events** — Store conversation summaries with action items
- **Real-time Transcripts** — Capture live transcript segments
- **Audio Bytes** — Optionally store raw PCM16 audio
- **Agent Notifications** — Trigger agent context with new memories

## Installation

The plugin is auto-discovered from `~/.openclaw/extensions/omimesh/`.

Enable it in your OpenClaw config:

```json5
{
  plugins: {
    entries: {
      omimesh: {
        enabled: true,
        config: {
          storeMemories: true,
          storeTranscripts: true,
          storeAudio: false,
          memoryPath: "memory/omi",
          notifyAgent: true
        }
      }
    }
  }
}
```

## Webhook Endpoints

After enabling, these endpoints are available on your Gateway:

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/omimesh/memory` | POST | Memory creation events |
| `/omimesh/transcript` | POST | Real-time transcript segments |
| `/omimesh/audio` | POST | Raw audio bytes (PCM16) |
| `/omimesh/status` | GET | Plugin health check |

## Configuring Omi App

1. Open Omi app → Developer Settings
2. Enable the webhooks you want
3. Enter your Gateway URL for each endpoint

For external access, use ngrok:
```bash
ngrok http 18789
```

Then configure Omi with URLs like:
```
https://abc123.ngrok.io/omimesh/memory
https://abc123.ngrok.io/omimesh/transcript
```

## CLI Commands

```bash
openclaw omimesh status  # Show plugin configuration
openclaw omimesh urls    # Show webhook URLs to configure
```

## Data Storage

Data is stored in your workspace under the configured `memoryPath`:

```
memory/omi/
├── 2024-02-14.md              # Daily memories (markdown)
├── transcripts/
│   └── 2024-02-14-abc123.jsonl  # Transcript segments (JSONL)
└── audio/
    └── 2024-02-14-10-30-00-uid.pcm  # Raw audio (if enabled)
```

### Memory Format

Each memory is formatted as:

```markdown
## 📅 Project Timeline Discussion
*10:30 AM — work*

Brief overview of the conversation...

**Action Items:**
- [ ] Send project proposal by Friday

<details>
<summary>Transcript</summary>

**SPEAKER_00:** Let's discuss the project timeline.
**You:** Sounds good, let me pull up the schedule.

</details>
```

## Configuration Options

| Option | Type | Default | Description |
|--------|------|---------|-------------|
| `webhookSecret` | string | - | Secret for webhook verification |
| `storeMemories` | boolean | true | Store memory creation events |
| `storeTranscripts` | boolean | true | Store real-time transcripts |
| `storeAudio` | boolean | false | Store raw audio (heavy!) |
| `memoryPath` | string | "memory/omi" | Storage path in workspace |
| `notifyAgent` | boolean | false | Send system event on new memories |

## About

OmiMesh bridges your physical conversations to your AI agent's memory.

Built by Morpheus 🔮 for Julio
